/*- Stepper full -
 * This example demonstrates the basic usage of a Phidget Stepper controller.  It demonstrates the manipulation 
 * of the velocity, goal position and acceleration of the stepper, as well as displays the data from generated 
 * events including current position.  If the connected Phidget STepper is Bipolar, the user will be shown 
 * Current values as well as being able to manipulate stepper torque.
 *
 * Please note that this example was designed to work with only one Phidget Stepper connected. 
 * For an example using multiple Phidget Stepper, please see a "multiple" example in the Full Examples folder.
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package Stepper;

import com.phidgets.StepperPhidget;
import com.phidgets.PhidgetException;

import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

import listeners.*;

public class Stepper extends javax.swing.JFrame {
    
    private static String runArgs[];
    private StepperPhidget stepper;
    private StepperAttachListener attach_listener;
    private StepperDetachListener detach_listener;
    private StepperErrorListener error_listener;
    private StepperCurrentChangeListener current_listener;
    private StepperInputChangeListener input_listener;
    private StepperPositionListener position_listener;
    private StepperVelocityListener velocity_listener;
    private JCheckBox inputArray[];
    private int targetPosArray[]; //array to hold the set goal values for each stepper
    
    /** Creates new form Stepper */
    public Stepper() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPanel2 = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        motorCmb = new javax.swing.JComboBox();
        velTxt = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        accelTxt = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        posTxt = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        targetPosTxt = new javax.swing.JTextField();
        jLabel10 = new javax.swing.JLabel();
        torqueTxt = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        currentTxt = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        jLabel14 = new javax.swing.JLabel();
        velScrl = new javax.swing.JSlider();
        accelScrl = new javax.swing.JSlider();
        jLabel15 = new javax.swing.JLabel();
        targetPosScrl = new javax.swing.JSlider();
        jLabel16 = new javax.swing.JLabel();
        torqueScrl = new javax.swing.JSlider();
        jPanel1 = new javax.swing.JPanel();
        attachedTxt = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        serialTxt = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        versionTxt = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        numMotorsTxt = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        numInTxt = new javax.swing.JTextField();
        jLabel17 = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        in0Chk = new javax.swing.JCheckBox();
        in1Chk = new javax.swing.JCheckBox();
        in2Chk = new javax.swing.JCheckBox();
        in3Chk = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Stepper - full");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Motor Data"));
        jLabel6.setText("Choose Stepper Motor:");

        motorCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                motorCmbActionPerformed(evt);
            }
        });

        velTxt.setEditable(false);

        jLabel7.setText("Velocity:");

        accelTxt.setEditable(false);

        jLabel8.setText("Acceleration:");

        posTxt.setEditable(false);

        jLabel9.setText("Position:");

        targetPosTxt.setEditable(false);

        jLabel10.setText("Target Position:");

        torqueTxt.setEditable(false);

        jLabel11.setText("Torque:");

        currentTxt.setEditable(false);

        jLabel12.setText("Current:");

        jLabel13.setText("Set Maximum Velocity:");

        jLabel14.setText("Set Acceleration:");

        velScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                velScrlStateChanged(evt);
            }
        });

        accelScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                accelScrlStateChanged(evt);
            }
        });

        jLabel15.setText("Set Target Position:");

        targetPosScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                targetPosScrlStateChanged(evt);
            }
        });

        jLabel16.setText("Set Torque:");

        torqueScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                torqueScrlStateChanged(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(targetPosScrl, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 294, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(velScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 132, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                    .add(jLabel13))
                                .add(26, 26, 26))
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                                    .add(jLabel7)
                                    .add(jLabel6)
                                    .add(jLabel8)
                                    .add(jLabel9))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED))
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                                    .add(jLabel11)
                                    .add(jLabel10)
                                    .add(jLabel12))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)))
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, velTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, posTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, targetPosTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, torqueTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, currentTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, accelScrl, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, accelTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 136, Short.MAX_VALUE)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, jLabel14)
                            .add(org.jdesktop.layout.GroupLayout.LEADING, motorCmb, 0, 136, Short.MAX_VALUE)))
                    .add(jLabel15)
                    .add(jLabel16)
                    .add(torqueScrl, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 294, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(motorCmb, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabel6))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(velTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabel7))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(jLabel8)
                            .add(accelTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(posTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabel9))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(targetPosTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabel10))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(torqueTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabel11))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(currentTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jLabel12))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jLabel14)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(accelScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(jLabel13)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(velScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel15)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(targetPosScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel16)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(torqueScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Stepper Info"));
        attachedTxt.setEditable(false);

        jLabel1.setText("Attached:");

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setFont(new java.awt.Font("Tahoma", 0, 11));
        nameTxt.setLineWrap(true);
        nameTxt.setRows(3);
        nameTxt.setTabSize(2);
        nameTxt.setWrapStyleWord(true);
        jScrollPane1.setViewportView(nameTxt);

        jLabel2.setText("Name:");

        serialTxt.setEditable(false);

        jLabel3.setText("Serial No.:");

        versionTxt.setEditable(false);

        jLabel4.setText("Version:");

        numMotorsTxt.setEditable(false);

        jLabel5.setText("Motors:");

        numInTxt.setEditable(false);

        jLabel17.setText("Inputs:");

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(35, 35, 35)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jLabel1)
                    .add(jLabel2)
                    .add(jLabel4)
                    .add(jLabel3)
                    .add(jLabel5)
                    .add(jLabel17))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, numInTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, numMotorsTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, versionTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, serialTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, attachedTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1))
                .addContainerGap(59, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(attachedTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel1))
                .add(15, 15, 15)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel2))
                .add(16, 16, 16)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(serialTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel3))
                .add(16, 16, 16)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(versionTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel4))
                .add(15, 15, 15)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(numMotorsTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel5))
                .add(19, 19, 19)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(numInTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel17))
                .addContainerGap(24, Short.MAX_VALUE))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Input Data"));
        jPanel3.setMaximumSize(new java.awt.Dimension(249, 51));
        in0Chk.setText("Input 0");
        in0Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in0Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        in1Chk.setText("Input 1");
        in1Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in1Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        in2Chk.setText("Input 2");
        in2Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in2Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        in3Chk.setText("Input 3");
        in3Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in3Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(40, 40, 40)
                .add(in0Chk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(in1Chk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(in2Chk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(in3Chk)
                .addContainerGap(44, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(in0Chk)
                    .add(in1Chk)
                    .add(in2Chk)
                    .add(in3Chk))
                .addContainerGap(23, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {jPanel1, jPanel2, jPanel3}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * initialize the stepper object and hook the event listeners
     **/
    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        inputArray = new JCheckBox[4];
        
        inputArray[0] = in0Chk;
        inputArray[1] = in1Chk;
        inputArray[2] = in2Chk;
        inputArray[3] = in3Chk;
        
        for(int i = 0; i < 4; i++)
        {
            inputArray[i].setVisible(false);
            inputArray[i].setEnabled(false);
        }
        
        motorCmb.setEnabled(false);
        velScrl.setEnabled(false);
        accelScrl.setEnabled(false);
        targetPosScrl.setEnabled(false);
        
        jLabel11.setVisible(false);
        torqueTxt.setVisible(false);
        
        jLabel16.setVisible(false);
        torqueScrl.setEnabled(false);
        torqueScrl.setVisible(false);
        
        jLabel12.setVisible(false);
        currentTxt.setVisible(false);
        
        try
        {
            stepper = new StepperPhidget();
            
            attach_listener = new StepperAttachListener(this, this.attachedTxt,
                    this.nameTxt, this.serialTxt, this.versionTxt,
                    this.numMotorsTxt, this.numInTxt, this.motorCmb,
                    this.velTxt, this.accelTxt, this.posTxt,
                    this.targetPosTxt, this.torqueTxt, this.currentTxt,
                    this.velScrl, this.accelScrl, this.targetPosScrl,
                    this.torqueScrl, this.inputArray, this.jLabel11,
                    this.jLabel12, this.jLabel16, this.targetPosArray);
            
            detach_listener = new StepperDetachListener(this, this.attachedTxt,
                    this.nameTxt, this.serialTxt, this.versionTxt,
                    this.numMotorsTxt, this.numInTxt, this.motorCmb,
                    this.velTxt, this.accelTxt, this.posTxt,
                    this.targetPosTxt, this.torqueTxt, this.currentTxt,
                    this.velScrl, this.accelScrl, this.targetPosScrl,
                    this.torqueScrl, this.inputArray, this.jLabel11,
                    this.jLabel12, this.jLabel16, this.targetPosArray);
            
            error_listener = new StepperErrorListener(this);
            
            current_listener = new StepperCurrentChangeListener(this.motorCmb, this.currentTxt);
            
            input_listener = new StepperInputChangeListener(this.inputArray);
            
            position_listener = new StepperPositionListener(this.motorCmb, this.posTxt);
            
            velocity_listener = new StepperVelocityListener(this.motorCmb, this.velTxt);
            
            stepper.addAttachListener(attach_listener);
            stepper.addDetachListener(detach_listener);
            stepper.addErrorListener(error_listener);
            stepper.addCurrentChangeListener(current_listener);
            stepper.addInputChangeListener(input_listener);
            stepper.addStepperPositionChangeListener(position_listener);
            stepper.addStepperVelocityChangeListener(velocity_listener);
            
            //This assumes that if there is a command line argument, it is a serial number
            //and we try to open that specific device. Otherwise, open any device.
            if((runArgs.length > 1) && (runArgs[1].equals("remote")))
            {
                stepper.open(Integer.parseInt(runArgs[0]), null);
            }
            else if(runArgs.length > 0)
            {
                stepper.open(Integer.parseInt(runArgs[0]));
            }
            else
            {
                stepper.openAny();
            }
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_formWindowOpened

    private void motorCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_motorCmbActionPerformed
        if(motorCmb.isEnabled())
        {
            try
            {
                //velTxt.setText(Double.toString(stepper.getMaxVelocity(((Integer)motorCmb.getSelectedItem()).intValue())));
		    velTxt.setText("0");
                velScrl.setValueIsAdjusting(true);
                //velScrl.setValue((int)stepper.getMaxVelocity(((Integer)motorCmb.getSelectedItem()).intValue()));
		    velScrl.setValue(0);
                velScrl.setValueIsAdjusting(false);

                accelTxt.setText(Double.toString(stepper.getAcceleration(((Integer)motorCmb.getSelectedItem()).intValue())));
                accelScrl.setValueIsAdjusting(true);
                accelScrl.setValue((int)stepper.getAcceleration(((Integer)motorCmb.getSelectedItem()).intValue()));
                accelScrl.setValueIsAdjusting(false);

                posTxt.setText(Long.toString(stepper.getPosition(((Integer)motorCmb.getSelectedItem()).intValue())));
                targetPosTxt.setText(Integer.toString(targetPosArray[((Integer)motorCmb.getSelectedItem()).intValue()]));
                targetPosScrl.setValueIsAdjusting(true);
                targetPosScrl.setValue(targetPosArray[((Integer)motorCmb.getSelectedItem()).intValue()]);
                targetPosScrl.setValueIsAdjusting(false);
            }
            catch(PhidgetException ex)
            {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }//GEN-LAST:event_motorCmbActionPerformed

    private void velScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_velScrlStateChanged
        if(velScrl.isEnabled())
        {
            try
            {
                stepper.setMaxVelocity(((Integer)motorCmb.getSelectedItem()).intValue(), (double)velScrl.getValue());
                
            }
            catch(PhidgetException ex)
            {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
                attachedTxt.setText("false");
                nameTxt.setText("");
                serialTxt.setText("");
                versionTxt.setText("");
                numMotorsTxt.setText("");
                numInTxt.setText("");

                motorCmb.removeAllItems();
                motorCmb.setSelectedIndex(0);
                motorCmb.setEnabled(false);

                if(nameTxt.getText().compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0)
                {
                    jLabel16.setVisible(false);
                    torqueScrl.setEnabled(false);
                    torqueScrl.setValue(0);
                    torqueScrl.setVisible(false);

                    jLabel11.setVisible(false);
                    torqueTxt.setText("");
                    torqueTxt.setVisible(false);

                    jLabel12.setVisible(false);
                    currentTxt.setText("");
                    currentTxt.setVisible(false);
                }

                velTxt.setText("");
                accelTxt.setText("");
                posTxt.setText("");
                targetPosTxt.setText("");

                velScrl.setEnabled(false);
                velScrl.setValue(0);
                accelScrl.setEnabled(false);
                accelScrl.setValue(0);
                targetPosScrl.setEnabled(false);
                targetPosScrl.setValue(0);

                int i;
                for(i = 0; i < 4; i++)
                {
                    inputArray[i].setVisible(false);
                }
            }
        }
    }//GEN-LAST:event_velScrlStateChanged

    private void accelScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_accelScrlStateChanged
        if(accelScrl.isEnabled())
        {
            try
            {
                stepper.setAcceleration(((Integer)motorCmb.getSelectedItem()).intValue(), (double)accelScrl.getValue());
                accelTxt.setText(Double.toString(stepper.getAcceleration(((Integer)motorCmb.getSelectedItem()).intValue())));
            }
            catch(PhidgetException ex)
            {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
                attachedTxt.setText("false");
                nameTxt.setText("");
                serialTxt.setText("");
                versionTxt.setText("");
                numMotorsTxt.setText("");
                numInTxt.setText("");

                motorCmb.removeAllItems();
                motorCmb.setSelectedIndex(0);
                motorCmb.setEnabled(false);

                if(nameTxt.getText().compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0)
                {
                    jLabel16.setVisible(false);
                    torqueScrl.setEnabled(false);
                    torqueScrl.setValue(0);
                    torqueScrl.setVisible(false);

                    jLabel11.setVisible(false);
                    torqueTxt.setText("");
                    torqueTxt.setVisible(false);

                    jLabel12.setVisible(false);
                    currentTxt.setText("");
                    currentTxt.setVisible(false);
                }

                velTxt.setText("");
                accelTxt.setText("");
                posTxt.setText("");
                targetPosTxt.setText("");

                velScrl.setEnabled(false);
                velScrl.setValue(0);
                accelScrl.setEnabled(false);
                accelScrl.setValue(0);
                targetPosScrl.setEnabled(false);
                targetPosScrl.setValue(0);

                int i;
                for(i = 0; i < 4; i++)
                {
                    inputArray[i].setVisible(false);
                }
            }
        }
    }//GEN-LAST:event_accelScrlStateChanged

    private void targetPosScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_targetPosScrlStateChanged
        if(targetPosScrl.isEnabled())
        {
            try
            {
                stepper.setPosition(((Integer)motorCmb.getSelectedItem()).intValue(), (long)targetPosScrl.getValue());
                targetPosArray[((Integer)motorCmb.getSelectedItem()).intValue()] = targetPosScrl.getValue();
                targetPosTxt.setText(Integer.toString(targetPosArray[((Integer)motorCmb.getSelectedItem()).intValue()]));
            }
            catch(PhidgetException ex)
            {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
                attachedTxt.setText("false");
                nameTxt.setText("");
                serialTxt.setText("");
                versionTxt.setText("");
                numMotorsTxt.setText("");
                numInTxt.setText("");

                motorCmb.removeAllItems();
                motorCmb.setSelectedIndex(0);
                motorCmb.setEnabled(false);

                if(nameTxt.getText().compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0)
                {
                    jLabel16.setVisible(false);
                    torqueScrl.setEnabled(false);
                    torqueScrl.setValue(0);
                    torqueScrl.setVisible(false);

                    jLabel11.setVisible(false);
                    torqueTxt.setText("");
                    torqueTxt.setVisible(false);

                    jLabel12.setVisible(false);
                    currentTxt.setText("");
                    currentTxt.setVisible(false);
                }

                velTxt.setText("");
                accelTxt.setText("");
                posTxt.setText("");
                targetPosTxt.setText("");

                velScrl.setEnabled(false);
                velScrl.setValue(0);
                accelScrl.setEnabled(false);
                accelScrl.setValue(0);
                targetPosScrl.setEnabled(false);
                targetPosScrl.setValue(0);

                int i;
                for(i = 0; i < 4; i++)
                {
                    inputArray[i].setVisible(false);
                }
            }
        }
    }//GEN-LAST:event_targetPosScrlStateChanged

    private void torqueScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_torqueScrlStateChanged
        if(torqueScrl.isEnabled())
        {
            try
            {
                stepper.setTorque(((Integer)motorCmb.getSelectedItem()).intValue(), (double)torqueScrl.getValue());
                torqueTxt.setText(Integer.toString(torqueScrl.getValue()));
            }
            catch(PhidgetException ex)
            {
                JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
                attachedTxt.setText("false");
                nameTxt.setText("");
                serialTxt.setText("");
                versionTxt.setText("");
                numMotorsTxt.setText("");
                numInTxt.setText("");

                motorCmb.removeAllItems();
                motorCmb.setSelectedIndex(0);
                motorCmb.setEnabled(false);

                if(nameTxt.getText().compareTo("Phidget Bipolar Stepper Controller 1-motor") == 0)
                {
                    jLabel16.setVisible(false);
                    torqueScrl.setEnabled(false);
                    torqueScrl.setValue(0);
                    torqueScrl.setVisible(false);

                    jLabel11.setVisible(false);
                    torqueTxt.setText("");
                    torqueTxt.setVisible(false);

                    jLabel12.setVisible(false);
                    currentTxt.setText("");
                    currentTxt.setVisible(false);
                }

                velTxt.setText("");
                accelTxt.setText("");
                posTxt.setText("");
                targetPosTxt.setText("");

                velScrl.setEnabled(false);
                velScrl.setValue(0);
                accelScrl.setEnabled(false);
                accelScrl.setValue(0);
                targetPosScrl.setEnabled(false);
                targetPosScrl.setValue(0);

                int i;
                for(i = 0; i < 4; i++)
                {
                    inputArray[i].setVisible(false);
                }
            }
        }
    }//GEN-LAST:event_torqueScrlStateChanged

    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        try
        {
            stepper.removeAttachListener(attach_listener);
            stepper.removeDetachListener(detach_listener);
            stepper.removeErrorListener(error_listener);
            stepper.removeCurrentChangeListener(current_listener);
            stepper.removeInputChangeListener(input_listener);
            stepper.removeStepperPositionChangeListener(position_listener);
            stepper.removeStepperVelocityChangeListener(velocity_listener);
            
            stepper.close();
            
            stepper = null;
            
            dispose();
            System.exit(0);
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
    }//GEN-LAST:event_formWindowClosed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new Stepper().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSlider accelScrl;
    private javax.swing.JTextField accelTxt;
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JTextField currentTxt;
    private javax.swing.JCheckBox in0Chk;
    private javax.swing.JCheckBox in1Chk;
    private javax.swing.JCheckBox in2Chk;
    private javax.swing.JCheckBox in3Chk;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JComboBox motorCmb;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JTextField numInTxt;
    private javax.swing.JTextField numMotorsTxt;
    private javax.swing.JTextField posTxt;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JSlider targetPosScrl;
    private javax.swing.JTextField targetPosTxt;
    private javax.swing.JSlider torqueScrl;
    private javax.swing.JTextField torqueTxt;
    private javax.swing.JSlider velScrl;
    private javax.swing.JTextField velTxt;
    private javax.swing.JTextField versionTxt;
    // End of variables declaration//GEN-END:variables
    
}
